/************************************************************************
 * FILE DESCR:	jv include flie
 *
 * CONTENTS:	
 *
 * AUTHOR:	Eric
 *
 * DATE:	** Fri Dec 13 14:37:39 2002 **
 ************************************************************************/

struct jv3_header {
    unsigned char	track;
    unsigned char	sector;
    unsigned char	flags;
};

struct jv3 {
    struct jv3_header	headers[2901];
    unsigned char	write_protect;
    char		*data;
    struct jv3_header	headers2[2901];
    unsigned char	padding;
    char		*data2;
};

#define JV3_DENSITY	0x80	/* 1=DD, 0=SD				*/
#define JV3_DAM_BITS	0x60	/* (SD) 0=0xfb, 1=0xfa, 2=0xf9, 3=0xf8	*/
				/* (DD) 0=0xfb, 1=0xf8, 2&3=not used	*/
#define JV3_SIDE_BITS	0x10	/* 0=side 0, 1=side 1			*/
#define JV3_CRC_ERROR	0x08	/* 0=ok, 1=CRC Error			*/
#define JV3_NOIBM	0x04	/* 0=normal, 1=short			*/
#define JV3_SIZE_BITS	0x03	/* 0=256, 1=128, 2=1024, 3=512 (USED)	*/
                                /* 0=512, 1=1024, 2=128, 3=256 (FREE)	*/
#define JV3_FREE	0xff	/* in trck and sect fields of free sects*/
#define JV3_FREEF	0xfc	/* in flags fields, or'd with size code	*/

/* functions to make using the above easier	*/

#define JV3_IS_WRITE_PROTECT(jv3ptr)	(jv3ptr->write_protect == 0x00)
#define JV3_IS_PROPER_PADDING(jv3ptr)	(jv3ptr->padding == 0xff)

#define JV3_IS_DD(jv3hdr)		((jv3hdr.flags & JV3_DENSITY) != 0)
#define JV3_IS_SD(jv3hdr)		(!JV3_IS_DD(jv3hdr))

#define JV3_SIDE(jv3hdr)		((jv3hdr.flags & JV3_SIDE_BITS) >> 4)
#define JV3_HAS_CRC_ERROR(jv3hdr)	((jv3hdr.flags & JV3_CRC_ERROR) != 0)
#define JV3_IBM_EXTENDED(jv3hdr)	((jv3hdr.flags & JV3_NOIBM) != 0)

/*			    formula for DAM:
   (for single density)   			00 -> 1111 1011
   so, just get the dam bits			01 -> 1111 1010
   shifted into 0,1 (all other			10 -> 1111 1001
   zeros) then xor w/0xfb (1111 1011)		11 -> 1111 1000

   (for double density)
   Just look at the bits and return		00 -> 1111 1011
   the right value				01 -> 1111 1000
*/

#define JV3_SD_FORM(jv3hdr)	(((jv3hdr.flags & JV3_DAM_BITS)>>5)^0xfb)
#define JV3_DD_FORM(jv3hdr)	((jv3hdr.flags & JV3_DAM_BITS)?0xf8:0xfb)
#define JV3_DAM(jv3hdr)		(JV3_IS_DD(jv3hdr)?JV3_DD_FORM(jv3hdr):JV3_SD_FORM(jv3hdr))

#define JV3_IS_FREE_SEC(jv3hdr)	(jv3hdr.track == JV3_FREE || jv3hdr.sector == JV3_FREE)
#define JV3_SIZE_CODE(jv3hdr)	(JV3_IS_FREE_SEC(jv3hdr)?((jv3hdr.flags & JV3_SIZE_BITS)^2): \
				                         ((jv3hdr.flags & JV3_SIZE_BITS)^1))
#define JV3_SIZE(jv3hdr)	(128 << JV3_SIZE_CODE(jv3hdr))

#define JVC_ATTR_CRCERR		0x08
#define JVC_ATTR_SECTERR	0x10
#define JVC_ATTR_DELETED	0x20

/************************************************/
/* ERROR conditions				*/
/************************************************/

#define E_JV3_BAD_FORMAT	0x01
#define E_JV3_SIDE_INCON	0x02
#define E_JV3_DATA_SIZE		0x03

